import time,sys,thread

from Tkinter import *
from Numeric import *


class NumericInterface:
    def __init__(self, parent, child):
        ##  TKR is required to be placed HERE  ##
        self.tkr = parent
        self.numerics = child
        
        ##  Variable declaration  ##
        self.tvUseHamiltonian = BooleanVar()
        self.tvUseHamiltonian.set(self.numerics.tvUseHamiltonian)
        
        self.dtUpperLimit = 1000
        self.nUpperLimit = 3
        ##  Variable declaration  ##


        ##  TKR appearance and widget creation  ##
        self.tkr.wm_geometry(newGeometry="600x350+640+40")   
        self.tkr.wm_title("Numerical Controls")
        #
        self.tkr.topFrame = Frame(self.tkr, relief=SUNKEN, borderwidth=0)
        self.tkr.topFrame.grid(row=0, column=0, padx=0, pady=0)

        ###########################################################################
        self.tkr.scalesFrame = Frame(self.tkr.topFrame, relief=RAISED, borderwidth=0)
        self.tkr.scalesFrame.grid(row=0, column=0, padx=0, pady=3, sticky=W)
        #   
        self.tkr.scalesLabel = Label(self.tkr.scalesFrame, text="Configuration & Parameters:").grid(row=0, column=0, columnspan=4, pady=4, sticky=W)
        #
        self.tkr.JbxRatioWidget = Scale(self.tkr.scalesFrame, orient=VERTICAL, length=160, from_=4.0, to=-4.0, resolution=0.001, label="Jbx", command=lambda str: self.numerics.setJbx(str))
        self.tkr.JbxRatioWidget.set(self.numerics.Jbx)
        self.tkr.JbxRatioWidget.grid(row=1, column=0)
        #
        self.tkr.JbyRatioWidget = Scale(self.tkr.scalesFrame, orient=VERTICAL, length=160, from_=4.0, to=-4.0, resolution=0.001, label="Jby", command=lambda str: self.numerics.setJby(str))
        self.tkr.JbyRatioWidget.set(self.numerics.Jby)
        self.tkr.JbyRatioWidget.grid(row=1, column=1)
        #
        self.tkr.phiScaleWidget = Scale(self.tkr.scalesFrame, orient=VERTICAL, length=160, from_=3.1415, to=0.00, resolution=0.001, label="phiScale", command=lambda str: self.numerics.setPhiScale(str))
        self.tkr.phiScaleWidget.set(self.numerics.phiScale)
        self.tkr.phiScaleWidget.grid(row=1, column=2)
        #
        self.tkr.phiRatioWidget = Scale(self.tkr.scalesFrame, orient=VERTICAL, length=160, from_=1.00, to=-1.00, resolution=0.01, label="phiRatio", command=lambda str: self.numerics.setPhiRatio(str))
        self.tkr.phiRatioWidget.set(self.numerics.phiRatio)
        self.tkr.phiRatioWidget.grid(row=1, column=3)

##	self.tkr.PhaseWidget = Scale(self.tkr.scalesFrame, orient=VERTICAL, length=160, from_=3.1415, to=0.00, resolution=0.01, label="Phase", command=lambda str: self.numerics.setPhase(str))
##        self.tkr.PhaseWidget.set(self.numerics.phiArray[1][0])
##        self.tkr.PhaseWidget.grid(row=1, column=3)
        #
##	self.tkr.magS2Widget = Scale(self.tkr.scalesFrame, orient=VERTICAL, length=160, from_=2.00, to=0.00, resolution=0.1, label="magS2", command=lambda str: self.numerics.setMagS2(str))
##        self.tkr.magS2Widget.set(self.numerics.magS2)
##        self.tkr.magS2Widget.grid(row=1, column=4)
        ###########################################################################

        ###########################################################################
        self.tkr.scales2Frame = Frame(self.tkr.topFrame, relief=RAISED, borderwidth=0)
        self.tkr.scales2Frame.grid(row=0, column=1, padx=0, pady=3, sticky=N)
        #
        self.tkr.hamLabel = Label(self.tkr.scales2Frame, text="Hamiltonian:").grid(row=0, column=0, pady=4, sticky=W)
        self.tkr.hamWidget = Checkbutton(self.tkr.scales2Frame, text="", variable=self.tvUseHamiltonian, command=self.numerics.toggleUseHamiltonian)
        self.tkr.hamWidget.grid(row=0, column=1)
        #
        self.tkr.nWidget = Scale(self.tkr.scales2Frame, orient=VERTICAL, length=100, from_=self.nUpperLimit, to=-1, resolution=1, label="State", command=lambda str: self.numerics.setHamState(str))
        self.tkr.nWidget.set(self.numerics.n)
        self.tkr.nWidget.grid(row=1, column=0)
        #
        self.tkr.baseSigmaWidget = Scale(self.tkr.scales2Frame, orient=VERTICAL, length=100, from_=1.000, to=0.0, resolution=0.01, label="scale", command=lambda str: self.numerics.setBaseSigma(str))
        self.tkr.baseSigmaWidget.set(self.numerics.baseSigma)
        self.tkr.baseSigmaWidget.grid(row=1, column=1)
        ###########################################################################   

        ###########################################################################
        self.tkr.scales3Frame = Frame(self.tkr.topFrame, relief=RAISED, borderwidth=0)
        self.tkr.scales3Frame.grid(row=1, column=0, padx=0, pady=3, sticky=W)
        #
        self.tkr.scales3Label = Label(self.tkr.scales3Frame, text="Perturbation & Randomness:").grid(row=0, column=0, columnspan=4, pady=4, sticky=W)
        #
        self.tkr.EBuWidget = Scale(self.tkr.scales3Frame, orient=VERTICAL, length=100, from_=4.00, to=-4.00, resolution=0.01, label="EBu", command=lambda str: self.numerics.setEBu(str))
        self.tkr.EBuWidget.set(self.numerics.EBu)     
        self.tkr.EBuWidget.grid(row=1, column=0)
        #
        self.tkr.EBdWidget = Scale(self.tkr.scales3Frame, orient=VERTICAL, length=100, from_=4.00, to=-4.00, resolution=0.01, label="EBd", command=lambda str: self.numerics.setEBd(str))
        self.tkr.EBdWidget.set(self.numerics.EBu)     
        self.tkr.EBdWidget.grid(row=1, column=1)
        #
        self.tkr.tempWidget = Scale(self.tkr.scales3Frame, orient=VERTICAL, length=100, from_=1.0, to=0, resolution=0.01, label="kT", command=lambda str: self.numerics.setTemp(str))
        self.tkr.tempWidget.set(self.numerics.temp/self.numerics.Ja)
        self.tkr.tempWidget.grid(row=1, column=2)
        #
        self.tkr.randomizeWidget = Button(self.tkr.scales3Frame, text="Randomize", command=self.numerics.randomizeState).grid(row=1, column=3, padx=4, pady=0)
        self.tkr.distortWidget = Button(self.tkr.scales3Frame, text="Distort", command=self.numerics.distort).grid(row=1, column=4, padx=4, pady=0)
        ###########################################################################

        ###########################################################################
        self.tkr.scales4Frame = Frame(self.tkr.topFrame, relief=RAISED, borderwidth=0)
        self.tkr.scales4Frame.grid(row=1, column=1, padx=0, pady=3, sticky=W)
        #
        self.tkr.scales4Label = Label(self.tkr.scales4Frame, text="Time:").grid(row=0, column=0, columnspan=2, pady=4, sticky=W)
        #
        self.tkr.DtWidget = Scale(self.tkr.scales4Frame, orient=VERTICAL, length=100, from_=self.dtUpperLimit, to=0, label="dt", command=lambda str: self.numerics.setDt(str))
        self.tkr.DtWidget.set(self.numerics.dt*1000.0)
##                    x = 0
        self.tkr.DtWidget.grid(row=1, column=0, padx=4)
        #
        self.tkr.pauseWidget = Button(self.tkr.scales4Frame, text="Pause", command=self.numerics.freeze).grid(row=1, column=1, padx=4, pady=0)
        self.tkr.resetWidget = Button(self.tkr.scales4Frame, text="Reset", command=self.numerics.reset).grid(row=1, column=2, padx=4, pady=0)
        ###########################################################################
        ##  TKR appearance and widget creation  ##
      


